<?php
require_once '../config/config.php';

if (!isAdmin()) {
    redirect('../dashboard.php');
}

$db = Database::getInstance()->getConnection();

$export_type = $_GET['export'] ?? '';
$export_data = $_GET['data'] ?? 'prediksi'; // prediksi or warga

if ($export_type === 'pdf' || $export_type === 'excel') {
    if ($export_data === 'warga') {
        // Export data warga
        $stmt = $db->query("SELECT u.*, d.nama_dusun, des.nama_desa 
                           FROM users u 
                           LEFT JOIN dusun d ON u.dusun_id = d.id 
                           LEFT JOIN desa des ON d.desa_id = des.id 
                           WHERE u.role = 'warga' 
                           ORDER BY u.created_at DESC");
        $data = $stmt->fetchAll();
        
        if ($export_type === 'pdf') {
            require_once '../libs/fpdf/fpdf.php';
            
            $pdf = new FPDF('L'); // Landscape
            $pdf->AddPage();
            $pdf->SetFont('Arial', 'B', 16);
            $pdf->Cell(0, 10, 'Data Warga - SumberAI', 0, 1, 'C');
            $pdf->SetFont('Arial', '', 10);
            $pdf->Cell(0, 5, 'Tanggal Export: ' . date('d/m/Y H:i'), 0, 1, 'C');
            $pdf->Ln(5);
            
            $pdf->SetFont('Arial', 'B', 8);
            $pdf->Cell(8, 6, 'No', 1, 0, 'C');
            $pdf->Cell(30, 6, 'Nama Lengkap', 1, 0);
            $pdf->Cell(25, 6, 'No. KTP', 1, 0);
            $pdf->Cell(25, 6, 'Provinsi', 1, 0);
            $pdf->Cell(25, 6, 'Kabupaten', 1, 0);
            $pdf->Cell(25, 6, 'Kelurahan', 1, 0);
            $pdf->Cell(25, 6, 'Desa', 1, 0);
            $pdf->Cell(25, 6, 'Dusun', 1, 0);
            $pdf->Cell(15, 6, 'RT', 1, 0);
            $pdf->Cell(15, 6, 'RW', 1, 0);
            $pdf->Cell(30, 6, 'Email', 1, 0);
            $pdf->Cell(25, 6, 'No. HP', 1, 1);
            
            $pdf->SetFont('Arial', '', 7);
            $no = 1;
            foreach ($data as $row) {
                $pdf->Cell(8, 5, $no++, 1, 0, 'C');
                $pdf->Cell(30, 5, substr($row['nama_lengkap'], 0, 20), 1, 0);
                $pdf->Cell(25, 5, $row['no_ktp'] ?? '-', 1, 0);
                $pdf->Cell(25, 5, substr($row['provinsi'] ?? '-', 0, 15), 1, 0);
                $pdf->Cell(25, 5, substr($row['kabupaten'] ?? '-', 0, 15), 1, 0);
                $pdf->Cell(25, 5, substr($row['kelurahan'] ?? '-', 0, 15), 1, 0);
                $pdf->Cell(25, 5, substr($row['nama_desa'] ?? '-', 0, 15), 1, 0);
                $pdf->Cell(25, 5, substr($row['nama_dusun'] ?? '-', 0, 15), 1, 0);
                $pdf->Cell(15, 5, $row['rt'] ?? '-', 1, 0);
                $pdf->Cell(15, 5, $row['rw'] ?? '-', 1, 0);
                $pdf->Cell(30, 5, substr($row['email'] ?? '-', 0, 20), 1, 0);
                $pdf->Cell(25, 5, $row['no_hp'] ?? '-', 1, 1);
            }
            
            $pdf->Output('D', 'Data_Warga_' . date('Y-m-d') . '.pdf');
            exit;
        } elseif ($export_type === 'excel') {
            header('Content-Type: application/vnd.ms-excel; charset=utf-8');
            header('Content-Disposition: attachment; filename="Data_Warga_' . date('Y-m-d') . '.xls"');
            
            echo '<meta http-equiv="Content-Type" content="text/html; charset=utf-8">';
            echo '<table border="1">';
            echo '<tr><th colspan="12">Data Warga - SumberAI</th></tr>';
            echo '<tr><th colspan="12">Tanggal Export: ' . date('d/m/Y H:i') . '</th></tr>';
            echo '<tr>';
            echo '<th>No</th><th>Nama Lengkap</th><th>No. KTP</th><th>Provinsi</th><th>Kabupaten</th>';
            echo '<th>Kelurahan</th><th>Desa</th><th>Dusun</th><th>RT</th><th>RW</th><th>Email</th><th>No. HP</th>';
            echo '</tr>';
            
        }
            
            
            
            $no = 1;
            foreach ($data as $row) {
                echo '<tr>';
                echo '<td>' . $no++ . '</td>';
                echo '<td>' . htmlspecialchars($row['nama_lengkap']) . '</td>';
                echo '<td>' . htmlspecialchars($row['no_ktp'] ?? '-') . '</td>';
                echo '<td>' . htmlspecialchars($row['provinsi'] ?? '-') . '</td>';
                echo '<td>' . htmlspecialchars($row['kabupaten'] ?? '-') . '</td>';
                echo '<td>' . htmlspecialchars($row['kelurahan'] ?? '-') . '</td>';
                echo '<td>' . htmlspecialchars($row['nama_desa'] ?? '-') . '</td>';
                echo '<td>' . htmlspecialchars($row['nama_dusun'] ?? '-') . '</td>';
                echo '<td>' . htmlspecialchars($row['rt'] ?? '-') . '</td>';
                echo '<td>' . htmlspecialchars($row['rw'] ?? '-') . '</td>';
                echo '<td>' . htmlspecialchars($row['email'] ?? '-') . '</td>';
                echo '<td>' . htmlspecialchars($row['no_hp'] ?? '-') . '</td>';
                echo '</tr>';
            }
            
            echo '</table>';
            exit;
        }
    }
    
    // Export prediksi (existing code)
    if ($export_data === 'prediksi') {
    // Get data
    $start_date = $_GET['start_date'] ?? date('Y-m-01');
    $end_date = $_GET['end_date'] ?? date('Y-m-d');
    
    $stmt = $db->prepare("SELECT 
        p.*, d.nama_dusun, des.nama_desa,
        COUNT(DISTINCT l.id) as jumlah_laporan,
        COUNT(DISTINCT dt.id) as jumlah_distribusi
        FROM prediksi_kekeringan p
        JOIN dusun d ON p.dusun_id = d.id
        JOIN desa des ON d.desa_id = des.id
        LEFT JOIN laporan_warga l ON d.id = l.dusun_id AND l.tanggal BETWEEN ? AND ?
        LEFT JOIN distribusi_tangki dt ON d.id = dt.dusun_id AND dt.tanggal_jadwal BETWEEN ? AND ?
        WHERE p.tanggal_prediksi BETWEEN ? AND ?
        GROUP BY p.id
        ORDER BY p.skor_risiko DESC");
    $stmt->execute([$start_date, $end_date, $start_date, $end_date, $start_date, $end_date]);
    $data = $stmt->fetchAll();
    
    if ($export_type === 'pdf') {
        require_once '../libs/fpdf/fpdf.php';
        
        $pdf = new FPDF();
        $pdf->AddPage();
        $pdf->SetFont('Arial', 'B', 16);
        $pdf->Cell(0, 10, 'Laporan Sistem SumberAI', 0, 1, 'C');
        $pdf->SetFont('Arial', '', 10);
        $pdf->Cell(0, 5, 'Periode: ' . formatDate($start_date) . ' - ' . formatDate($end_date), 0, 1, 'C');
        $pdf->Ln(10);
        
        $pdf->SetFont('Arial', 'B', 10);
        $pdf->Cell(40, 7, 'Desa', 1, 0);
        $pdf->Cell(40, 7, 'Dusun', 1, 0);
        $pdf->Cell(30, 7, 'Risiko', 1, 0);
        $pdf->Cell(30, 7, 'Skor', 1, 0);
        $pdf->Cell(25, 7, 'Laporan', 1, 0);
        $pdf->Cell(25, 7, 'Distribusi', 1, 1);
        
        $pdf->SetFont('Arial', '', 9);
        foreach ($data as $row) {
            $pdf->Cell(40, 6, substr($row['nama_desa'], 0, 20), 1, 0);
            $pdf->Cell(40, 6, substr($row['nama_dusun'], 0, 20), 1, 0);
            $pdf->Cell(30, 6, ucfirst($row['tingkat_risiko']), 1, 0);
            $pdf->Cell(30, 6, number_format($row['skor_risiko'], 2), 1, 0);
            $pdf->Cell(25, 6, $row['jumlah_laporan'], 1, 0);
            $pdf->Cell(25, 6, $row['jumlah_distribusi'], 1, 1);
        }
        
        $pdf->Output('D', 'Laporan_SumberAI_' . date('Y-m-d') . '.pdf');
        exit;
    } elseif ($export_type === 'excel') {
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment; filename="Laporan_SumberAI_' . date('Y-m-d') . '.xls"');
        
        echo '<table border="1">';
        echo '<tr><th colspan="6">Laporan Sistem SumberAI</th></tr>';
        echo '<tr><th colspan="6">Periode: ' . formatDate($start_date) . ' - ' . formatDate($end_date) . '</th></tr>';
        echo '<tr><th>Desa</th><th>Dusun</th><th>Risiko</th><th>Skor</th><th>Laporan</th><th>Distribusi</th></tr>';
        
        foreach ($data as $row) {
            echo '<tr>';
            echo '<td>' . htmlspecialchars($row['nama_desa']) . '</td>';
            echo '<td>' . htmlspecialchars($row['nama_dusun']) . '</td>';
            echo '<td>' . ucfirst($row['tingkat_risiko']) . '</td>';
            echo '<td>' . number_format($row['skor_risiko'], 2) . '</td>';
            echo '<td>' . $row['jumlah_laporan'] . '</td>';
            echo '<td>' . $row['jumlah_distribusi'] . '</td>';
            echo '</tr>';
        }
        
        echo '</table>';
        exit;
    }
}

// Get statistics
$stats = [];
$stats['total_prediksi'] = $db->query("SELECT COUNT(*) FROM prediksi_kekeringan WHERE tanggal_prediksi >= CURDATE()")->fetchColumn();
$stats['total_laporan'] = $db->query("SELECT COUNT(*) FROM laporan_warga")->fetchColumn();
$stats['total_distribusi'] = $db->query("SELECT COUNT(*) FROM distribusi_tangki")->fetchColumn();
$stats['kering'] = $db->query("SELECT COUNT(*) FROM prediksi_kekeringan WHERE tingkat_risiko = 'kering' AND tanggal_prediksi >= CURDATE()")->fetchColumn();

?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Laporan Sistem - <?php echo APP_NAME; ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <aside class="sidebar">
        <div class="sidebar-header">
            <h2><i class="fas fa-tint"></i> <?php echo APP_NAME; ?></h2>
        </div>
        <nav class="sidebar-nav">
            <a href="../dashboard.php" class="nav-item">
                <i class="fas fa-home"></i>
                <span>Dashboard</span>
            </a>
            <a href="users.php" class="nav-item">
                <i class="fas fa-users"></i>
                <span>Kelola Pengguna</span>
            </a>
            <a href="desa.php" class="nav-item">
                <i class="fas fa-building"></i>
                <span>Kelola Desa</span>
            </a>
            <a href="menu_icons.php" class="nav-item">
                <i class="fas fa-palette"></i>
                <span>Kelola Menu</span>
            </a>
            <a href="laporan.php" class="nav-item active">
                <i class="fas fa-chart-bar"></i>
                <span>Laporan Sistem</span>
            </a>
            <a href="../auth/logout.php" class="nav-item">
                <i class="fas fa-sign-out-alt"></i>
                <span>Logout</span>
            </a>
        </nav>
    </aside>
    
    <main class="main-content">
        <header class="content-header">
            <div class="header-left">
                <h1><i class="fas fa-chart-bar"></i> Laporan Sistem</h1>
                <p>Laporan dan statistik sistem</p>
            </div>
        </header>

        <!-- Statistics -->
        <div class="stats-grid">
            <div class="stat-card">
                <div class="stat-icon" style="background: #3498db;">
                    <i class="fas fa-chart-line"></i>
                </div>
                <div class="stat-info">
                    <h3><?php echo $stats['total_prediksi']; ?></h3>
                    <p>Total Prediksi</p>
                </div>
            </div>
            <div class="stat-card">
                <div class="stat-icon" style="background: #f39c12;">
                    <i class="fas fa-file-alt"></i>
                </div>
                <div class="stat-info">
                    <h3><?php echo $stats['total_laporan']; ?></h3>
                    <p>Total Laporan</p>
                </div>
            </div>
            <div class="stat-card">
                <div class="stat-icon" style="background: #9b59b6;">
                    <i class="fas fa-truck"></i>
                </div>
                <div class="stat-info">
                    <h3><?php echo $stats['total_distribusi']; ?></h3>
                    <p>Total Distribusi</p>
                </div>
            </div>
            <div class="stat-card">
                <div class="stat-icon" style="background: #e74c3c;">
                    <i class="fas fa-exclamation-triangle"></i>
                </div>
                <div class="stat-info">
                    <h3><?php echo $stats['kering']; ?></h3>
                    <p>Zona Kering</p>
                </div>
            </div>
        </div>

        <!-- Export Laporan Prediksi -->
        <div class="content-section">
            <h2><i class="fas fa-chart-line"></i> Export Laporan Prediksi</h2>
            <form method="GET" class="form-container">
                <input type="hidden" name="data" value="prediksi">
                <div class="form-row">
                    <div class="form-group">
                        <label>Tanggal Mulai</label>
                        <input type="date" name="start_date" value="<?php echo date('Y-m-01'); ?>" required>
                    </div>
                    <div class="form-group">
                        <label>Tanggal Akhir</label>
                        <input type="date" name="end_date" value="<?php echo date('Y-m-d'); ?>" required>
                    </div>
                </div>
                <div class="form-group">
                    <button type="submit" name="export" value="pdf" class="btn btn-danger">
                        <i class="fas fa-file-pdf"></i> Export PDF
                    </button>
                    <button type="submit" name="export" value="excel" class="btn btn-success">
                        <i class="fas fa-file-excel"></i> Export Excel
                    </button>
                </div>
            </form>
        </div>

        <!-- Export Data Warga -->
        <div class="content-section">
            <h2><i class="fas fa-users"></i> Export Data Warga</h2>
            <p style="margin-bottom: 20px; color: #666;">
                Export data lengkap warga termasuk Nama Lengkap, No. KTP, Provinsi, Kabupaten, Kelurahan, Dusun, RT/RW, Email, dan No. HP
            </p>
            <form method="GET" class="form-container">
                <input type="hidden" name="data" value="warga">
                <div class="form-group">
                    <button type="submit" name="export" value="pdf" class="btn btn-danger">
                        <i class="fas fa-file-pdf"></i> Export PDF
                    </button>
                    <button type="submit" name="export" value="excel" class="btn btn-success">
                        <i class="fas fa-file-excel"></i> Export Excel
                    </button>
                </div>
            </form>
        </div>
    </main>

    <script src="../assets/js/main.js"></script>
</body>
</html>

